package com.atlassian.plugin;

/**
 * Applied to plugins that are capable of storing a set of module descriptors that have been added / removed over the
 * lifetime of the plugin.
 *
 * Dynamic modules remain for the lifetime of the plugin.
 *
 * Implementations are expected to be thread safe.
 *
 * @since 4.0.0
 */
public interface DynamicModulePlugin extends Plugin
{
    /**
     * Add a module descriptor.
     *
     * @param module to add
     * @return true if added, false if already present
     */
    boolean addDynamicModuleDescriptor(final ModuleDescriptor<?> module);

    /**
     * @return current set of dynamic module descriptors.
     */
    Iterable<ModuleDescriptor<?>> getDynamicModuleDescriptors();

    /**
     * Remove a module descriptor.
     *
     * @param module to remove
     * @return true if removed, false if not present
     */
    boolean removeDynamicModuleDescriptor(final ModuleDescriptor<?> module);
}
