/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.new_platform;

import com.atlassian.new_platform.BundleDependencies;
import com.atlassian.new_platform.BundleInfo;
import com.atlassian.new_platform.BundleRenderer;
import com.atlassian.new_platform.BundleUtils;
import com.atlassian.new_platform.GeneralUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Main {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            throw new RuntimeException("Expected arguments; path to the location with bundles");
        }
        if (args.length > 1) {
            System.out.println("WARNING Only first argument will be used!");
        }
        Path rootPath = Paths.get(args[0], new String[0]);
        Path libraries = rootPath.resolve("libraries");
        Path frameworkBundlesPath = rootPath.resolve("framework-bundles");
        Path bundledPluginsPath = rootPath.resolve("bundled-plugins");
        Path publicApiPath = rootPath.resolve("public-api");
        Path deprecatedApiPath = rootPath.resolve("deprecated-public-api");
        Path internalApiPath = rootPath.resolve("internal-api");
        Path output = rootPath.resolve("output");
        if (!Files.exists(output, new LinkOption[0])) {
            Files.createDirectory(output, new FileAttribute[0]);
        }
        List<BundleInfo> libs = BundleUtils.parseLibraries(libraries);
        List<BundleInfo> frameworkBundles = BundleUtils.parseBundles(frameworkBundlesPath);
        List<BundleInfo> bundledPlugins = BundleUtils.parseBundles(bundledPluginsPath);
        List<BundleInfo> publicApi = BundleUtils.parseLibraries(publicApiPath);
        List<BundleInfo> deprecatedApi = BundleUtils.parseLibraries(deprecatedApiPath);
        List<BundleInfo> internalApi = BundleUtils.parseLibraries(internalApiPath);
        BundleDependencies systemClasspathScope = new BundleDependencies(libs, libs);
        BundleRenderer bundleRenderer = new BundleRenderer(BundleUtils.mapToBundleNames(libs), BundleUtils.mapToBundleNames(frameworkBundles), BundleUtils.mapToBundleNames(bundledPlugins));
        BundleDependencies externalDeps = new BundleDependencies(GeneralUtils.concatLists(libs, frameworkBundles, bundledPlugins), GeneralUtils.concatLists(libs, frameworkBundles, bundledPlugins));
        System.out.println("List of libraries not used by any other bundle:");
        System.out.println(externalDeps.findNotUsedExports());
        System.out.println("All packages in platform components:");
        Map<String, List<String>> allInternalPackages = externalDeps.getAllInternalPackages();
        System.out.println(allInternalPackages);
        Map<String, Set<String>> importDependencies = externalDeps.getImportDependencies();
        bundleRenderer.renderDependencies(importDependencies, output.resolve("all_deps"));
        Map<String, List> reverse = importDependencies.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(val -> new AbstractMap.SimpleEntry<String, String>((String)val, (String)entry.getKey()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, entry -> Collections.singletonList((String)entry.getValue()), (xva$0, xva$1) -> GeneralUtils.concatLists(xva$0, xva$1)));
        reverse.entrySet().stream().sorted(Comparator.comparingInt(e -> ((List)e.getValue()).size())).forEach(entry -> {
            System.out.println((String)entry.getKey() + ": " + ((List)entry.getValue()).size());
            if (((List)entry.getValue()).size() == 1) {
                System.out.println("\t" + (String)((List)entry.getValue()).get(0));
            }
        });
        Map<String, Set<String>> allDependencies = externalDeps.getAllDependencies();
        Set deps = allDependencies.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set<String> leafs = allDependencies.keySet().stream().filter(dep -> !deps.contains(dep)).collect(Collectors.toSet());
        System.out.println();
        System.out.println("Found " + leafs.size() + " leafs");
        System.out.println();
        leafs.forEach(dep -> System.out.println("Leaf: " + dep));
    }
}

