/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.new_platform;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Descriptors;
import com.atlassian.new_platform.BundleInfo;
import com.atlassian.new_platform.GeneralUtils;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class BundleDependencies {
    private static final VersionRange INFINITY_VERSION_RANGE = VersionRange.valueOf((String)"0.0.0");
    private static final List<String> IGNORED_IMPORTS = Stream.of("java.", "javax.crypto", "javax.imageio", "javax.lang.model", "javax.management", "javax.naming", "javax.net", "javax.script", "javax.security", "javax.sql", "javax.swing", "javax.xml", "org.w3c.dom", "org.xml.sax", "org.ietf.jgss").collect(Collectors.toList());
    private final List<BundleInfo> exports;
    private final List<BundleInfo> imports;
    private final List<BundleInfo> all;

    public BundleDependencies(List<BundleInfo> exports, List<BundleInfo> imports) {
        this.exports = exports;
        this.imports = imports;
        this.all = Stream.concat(exports.stream(), imports.stream()).collect(Collectors.toList());
    }

    public Map<String, List<String>> findMissingImports() {
        return this.imports.stream().map(bundle -> new AbstractMap.SimpleEntry<String, List<String>>(bundle.getBundleName(), this.checkMissingImport((BundleInfo)bundle))).filter(entry -> !((List)entry.getValue()).isEmpty()).collect(GeneralUtils.unwrapMap());
    }

    public List<String> findNotUsedExports() {
        return this.exports.stream().filter(export -> this.imports.stream().flatMap(bundle -> bundle.getImports().stream().mapToObj(AbstractMap.SimpleEntry::new)).noneMatch(entry -> this.filterBundleWithExport((BundleInfo)export, (Descriptors.PackageRef)entry.getKey(), (Attrs)entry.getValue()))).map(BundleInfo::getBundleName).collect(Collectors.toList());
    }

    public Map<String, List<BundleInfo>> findDuplicatedExports() {
        Map<String, List> collect = this.all.stream().flatMap(bundle -> bundle.getExports().stream().mapToObj((pkg, attrs) -> new AbstractMap.SimpleEntry<String, BundleInfo>(pkg.getFQN(), (BundleInfo)bundle))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, entry -> Collections.singletonList((BundleInfo)entry.getValue()), (xva$0, xva$1) -> GeneralUtils.concatLists(xva$0, xva$1)));
        return collect.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(GeneralUtils.unwrapMap());
    }

    public Map<String, Set<String>> getImportDependencies() {
        return this.imports.stream().collect(Collectors.toMap(BundleInfo::getBundleName, b -> this.findDependencies((BundleInfo)b).stream().filter(bundle -> bundle != b).map(BundleInfo::getBundleName).collect(Collectors.toSet())));
    }

    public Map<String, Set<String>> getAllDependencies() {
        return this.all.stream().collect(Collectors.toMap(BundleInfo::getBundleName, b -> this.findDependencies((BundleInfo)b).stream().filter(bundle -> bundle != b).map(BundleInfo::getBundleName).collect(Collectors.toSet())));
    }

    public Map<String, List<String>> getAllInternalPackages() {
        return this.all.stream().flatMap(bundle -> bundle.getInternalPackages().stream().mapToObj((pkg, attrs) -> new AbstractMap.SimpleEntry<String, String>(pkg.getFQN(), bundle.getBundleName()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, entry -> Collections.singletonList((String)entry.getValue()), (xva$0, xva$1) -> GeneralUtils.concatLists(xva$0, xva$1)));
    }

    private Set<BundleInfo> findDependencies(BundleInfo bundle) {
        return bundle.getImports().stream().mapToObj(this::findDep).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Optional<BundleInfo> findDep(Descriptors.PackageRef packageRef, Attrs attrs) {
        return this.all.stream().filter(b -> this.filterBundleWithExport((BundleInfo)b, packageRef, attrs)).findFirst();
    }

    private List<String> checkMissingImport(BundleInfo bundleInfo) {
        return bundleInfo.getImports().stream().filter(this::filterMissing).mapToObj((p, attrs) -> p.getFQN()).collect(Collectors.toList());
    }

    private boolean filterMissing(Descriptors.PackageRef packageRef, Attrs attrs) {
        if (IGNORED_IMPORTS.stream().anyMatch(excl -> packageRef.getFQN().startsWith((String)excl))) {
            return false;
        }
        if ("optional".equals(attrs.get("resolution:"))) {
            return false;
        }
        return this.exports.stream().noneMatch(bundle -> this.filterBundleWithExport((BundleInfo)bundle, packageRef, attrs));
    }

    private boolean filterBundleWithExport(BundleInfo bundleInfo, Descriptors.PackageRef packageRef, Attrs attrs) {
        Attrs exportAttrs = bundleInfo.getExports().getByFQN(packageRef.getFQN());
        return exportAttrs != null;
    }

    private Version getVersion(String versionLiteral) {
        if (versionLiteral == null) {
            return Version.parseVersion((String)"0.0.0");
        }
        Object versionExport = versionLiteral.replace('-', '.');
        CharSequence[] split = ((String)versionExport).split("\\.");
        if (split.length > 0) {
            try {
                Integer.parseInt(split[0]);
            }
            catch (NumberFormatException e) {
                split[0] = "0";
            }
        }
        if (split.length > 1) {
            try {
                Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                split[1] = "0";
            }
        }
        if (split.length > 2) {
            try {
                Integer.parseInt((String)split[2]);
            }
            catch (NumberFormatException e) {
                split[2] = "0";
            }
        }
        versionExport = String.join((CharSequence)".", split);
        if (split.length > 4) {
            int i;
            versionExport = "";
            for (i = 0; i < 3; ++i) {
                versionExport = (String)versionExport + (String)split[i] + ".";
            }
            for (i = 3; i < split.length; ++i) {
                versionExport = (String)versionExport + (String)split[i] + "_";
            }
            versionExport = ((String)versionExport).substring(0, ((String)versionExport).length() - 1);
        }
        Version version = Version.parseVersion((String)versionExport);
        return version;
    }
}

