/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mtokarski;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
class OsgiImportExportParser {
    private StringBuilder buffer = new StringBuilder();
    private char[] chars;
    private int cursor;
    private String attrName;
    private List<String> packages;
    private Map<String, String> attributes;
    private Map<String, Map<String, String>> exports;

    OsgiImportExportParser() {
    }

    public Map<String, Map<String, String>> parseHeader(String value) {
        if (value == null) {
            return Collections.emptyMap();
        }
        this.packages = new ArrayList<String>();
        this.attributes = new HashMap<String, String>();
        this.exports = new HashMap<String, Map<String, String>>();
        this.chars = value.toCharArray();
        this.cursor = 0;
        while (this.cursor < this.chars.length) {
            switch (this.chars[this.cursor]) {
                case '\"': {
                    this.handleSpecialValue();
                    break;
                }
                case ':': {
                    this.handleDirectiveName();
                    break;
                }
                case '=': {
                    this.handleAttributeName();
                    break;
                }
                case ';': {
                    this.handlePackageOrParam();
                    break;
                }
                case ',': {
                    this.handleExport();
                    break;
                }
                default: {
                    this.buffer.append(this.chars[this.cursor]);
                }
            }
            ++this.cursor;
        }
        this.handleExport();
        return this.exports;
    }

    private void handleSpecialValue() {
        if (this.buffer.length() != 0 || this.attrName == null) {
            throw new RuntimeException("Unexpected occurrence of special attr value at char " + this.cursor);
        }
        ++this.cursor;
        while (this.cursor < this.chars.length && this.chars[this.cursor] != '\"') {
            this.buffer.append(this.chars[this.cursor]);
            ++this.cursor;
        }
    }

    private void handleDirectiveName() {
        if (this.chars[this.cursor + 1] != '=') {
            throw new RuntimeException("Cannot properly parse directive, error at char " + this.cursor);
        }
        this.handleAttributeName();
        ++this.cursor;
    }

    private void handleAttributeName() {
        this.attrName = this.buffer.toString();
        this.buffer = new StringBuilder();
    }

    private void handlePackageOrParam() {
        if (this.attrName != null) {
            this.attributes.put(this.attrName, this.buffer.toString());
            this.attrName = null;
        } else {
            this.packages.add(this.buffer.toString());
        }
        this.buffer = new StringBuilder();
    }

    private void handleExport() {
        if (this.buffer.length() != 0) {
            this.handlePackageOrParam();
        }
        this.packages.forEach(pack -> this.exports.put((String)pack, Collections.unmodifiableMap(this.attributes)));
        this.packages = new ArrayList<String>();
        this.attributes = new HashMap<String, String>();
    }
}

