/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.new_platform;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizCmdLineEngine;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Node;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class BundleRenderer {
    private final List<String> libraries;
    private final List<String> frameworkBundles;
    private final List<String> plugins;

    public BundleRenderer(List<String> libraries, List<String> frameworkBundles, List<String> plugins) {
        this.libraries = libraries;
        this.frameworkBundles = frameworkBundles;
        this.plugins = plugins;
    }

    public void renderDependencies(Map<String, Set<String>> allDependencies, Path path) throws IOException {
        List collect = allDependencies.entrySet().stream().map(entry -> ((Node)Factory.node((String)((String)entry.getKey())).with((Attributes)this.getColor((String)entry.getKey()))).link(((Set)entry.getValue()).stream().map(val -> Factory.to((Node)Factory.node((String)val)).with((Attributes)this.getColor((String)entry.getKey()))).collect(Collectors.toList()))).collect(Collectors.toList());
        Graph g = Factory.graph().directed().with(collect);
        Graphviz.useEngine((GraphvizEngine)new GraphvizCmdLineEngine().timeout(1, TimeUnit.MINUTES), (GraphvizEngine[])new GraphvizEngine[0]);
        Graphviz.fromGraph((Graph)g).render(Format.DOT).toFile(path.resolveSibling(path.getFileName() + ".dot").toFile());
        Graphviz.fromGraph((Graph)g).render(Format.SVG).toFile(path.resolveSibling(path.getFileName() + ".svg").toFile());
    }

    private Color getColor(String bundleName) {
        if (this.libraries.contains(bundleName)) {
            return Color.BLACK;
        }
        if (this.frameworkBundles.contains(bundleName)) {
            return Color.BLUE;
        }
        if (this.plugins.contains(bundleName)) {
            return Color.GREEN;
        }
        return Color.RED;
    }
}

