/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.new_platform;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import com.atlassian.new_platform.BundleInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class BundleUtils {
    private BundleUtils() {
    }

    public static BundleInfo extractBundleInfo(Path path) {
        try {
            String mavenModule = path.getFileName().toString().replace(".jar", "");
            Jar jarFile = new Jar(path.toFile());
            Analyzer analyzer = new Analyzer(jarFile);
            analyzer.analyze();
            String symbolicName = (String)analyzer.getBundleSymbolicName().getKey();
            Packages exports = analyzer.getExports();
            Packages imports = analyzer.getImports();
            Packages internal = analyzer.getContained();
            return new BundleInfo(mavenModule, imports, exports, internal);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static BundleInfo extractLibraryInfo(Path path) {
        String mavenModule = path.getFileName().toString().replace(".jar", "");
        try {
            Jar jar = new Jar(path.toFile());
            Analyzer analyzer = new Analyzer(jar);
            analyzer.setProperty("Export-Package", "*");
            analyzer.analyze();
            Packages imports = analyzer.getImports();
            Packages exports = analyzer.getExports();
            Packages internal = analyzer.getContained();
            Packages filteredExports = new Packages();
            exports.stream().filter((p, attrs) -> !p.getFQN().endsWith(String.valueOf('~'))).forEach((arg_0, arg_1) -> ((Packages)filteredExports).put(arg_0, arg_1));
            return new BundleInfo(mavenModule, imports, filteredExports, internal);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static List<BundleInfo> parseLibraries(Path root) throws IOException {
        return Files.list(root).map(BundleUtils::extractLibraryInfo).collect(Collectors.toList());
    }

    public static List<BundleInfo> parseBundles(Path root) throws IOException {
        return Files.list(root).map(BundleUtils::extractBundleInfo).collect(Collectors.toList());
    }

    public static List<String> mapToBundleNames(List<BundleInfo> bundles) {
        return bundles.stream().map(BundleInfo::getBundleName).collect(Collectors.toList());
    }
}

