package com.atlassian.maven.plugins.studio.validation

import com.atlassian.maven.plugins.studio.AbstractStudioMojo
import com.atlassian.maven.plugins.studio.util.PatchFile
import com.atlassian.maven.plugins.studio.util.PatchState
import org.apache.maven.project.MavenProject

/**
 * @goal patch-file
 */
class PatchFileMojo extends AbstractStudioMojo 
{
    /**
     * The Maven Projectpom
     *
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    MavenProject project
    
    /**
     * If ignorePatchFailures is true, failure to apply any patches won't fail the build
     *
     * @parameter expression="${ignore.patch.failures}" default-value="false"
     */
    boolean ignorePatchFailures
    
    void execute()
    {
        if(!PatchFile.applyPatches("$project.basedir/src/main/patches", project.getBuild().outputDirectory, log))
        {
            if(!ignorePatchFailures)
            {
                fail("There was a patch failure")
            }
        }
    }
}
