package com.atlassian.maven.plugins.studio.validation;

import com.atlassian.plugins.domain.model.plugin.Plugin
import org.apache.maven.artifact.Artifact

import java.util.Comparator;
import java.util.Locale;

import com.atlassian.plugins.domain.model.plugin.Plugin;
import com.atlassian.plugins.domain.model.plugin.PluginVersion

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion


public class DefaultPacValidator implements PacValidator {

    boolean notFoundIgnored;

    public String validate(Artifact artifact, List<Plugin> plugins, Locale locale) {
        String validationResult = null
        Plugin selectedPlugin = null
        if(plugins.size > 0) {
            //FIXME selection algorithm
            selectedPlugin = plugins.get(0)
        }
        if(selectedPlugin != null) {
            PluginVersion latestPluginVersion = selectedPlugin.latestVersion
            String latestPluginVersionString =latestPluginVersion.version

            if(new DefaultArtifactVersion (latestPluginVersionString).compareTo(new DefaultArtifactVersion (artifact.version)) > 0) {
                validationResult=String.format("Found newer version %s of plugin %s for artifact %s on PAC.", latestPluginVersionString, selectedPlugin.getPluginKey(), artifact)
            }
        }
        else if(!notFoundIgnored) {
            validationResult=String.format("Could not find corresponding plugin for artifact %s on PAC.", artifact)
        }
        return validationResult;
    }



}
