package com.atlassian.maven.plugins.studio.util

import com.atlassian.maven.plugins.studio.AbstractFireballMojo

public class JiraApplication extends AbstractTomcatApplication
{

    def JiraApplication(AbstractFireballMojo mojo)
    {
        this.mojo = mojo
        httpPort = mojo.jiraHttpPort
        rmiPort = mojo.jiraRmiPort
        debugPort = mojo.jiraDebugPort
        debugSuspend = mojo.jiraSuspend
        webAppName = "jira"
        contextPath = mojo.jiraContextPath
        warDirectory = mojo.jiraExplodedWarDirectory
        homeDirectory = mojo.jiraHome
        baseUrl = mojo.getBaseUrl("jira")
    }


    protected String getJvmArgs()
    {
        return "-Xms256m -Xmx768m -XX:MaxPermSize=512m ${devMode} ${memoryLogArgs} " +
                "-Dorg.apache.jasper.runtime.BodyContentImpl.LIMIT_BUFFER=true " +
                "-Datlassian.mail.senddisabled=false -Dstudio.webdav.directory=${mojo.webDavHomeDirectory} " +
                "${mojo.jiraJvmArgsExtra} ${mojo.jiraPluginResourceDirectories} ${mojo.halInstanceUriJvmArg}";
    }

    private String getDevMode()
    {
        mojo.debug ? "-Djira.dev.mode=true -Datlassian.dev.mode=true" : ""
    }

    private String getMemoryLogArgs()
    {
        (mojo.jiraMemoryLog ?
            "-XX:+PrintGCDetails -XX:+PrintGCTimeStamps -verbose:gc -Xloggc:./studio-fireball/target/gc-jira.log " : 
            "") +
                "-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=./studio-fireball/target/hprof_jira.hprof"
    }

    protected String getDatasource()
    {
        return "cargo.datasource.url=jdbc:hsqldb:${mojo.jiraHome}/database|cargo.datasource.driver=org.hsqldb.jdbcDriver|cargo.datasource.username=sa|cargo.datasource.password=|cargo.datasource.type=javax.sql.DataSource|cargo.datasource.jndi=jdbc/JiraDS";
    }

    String toString()
    {
        "JIRA"
    }

}