package com.atlassian.maven.plugins.studio.util

import com.atlassian.maven.plugins.studio.AbstractFireballMojo

public class FisheyeApplication implements Application
{
    private static final long FISHEYE_START_TIMEOUT = 240000

    AbstractFireballMojo mojo

    def FisheyeApplication(AbstractFireballMojo mojo)
    {
        this.mojo = mojo;
    }

    public void start(boolean parallel)
    {
        String fisheyeAppDir = "${mojo.explodedDirectory}/${mojo.fisheyeExplodedDirectory}"
        mojo.ant.java(jar: "${fisheyeAppDir}/fisheyeboot.jar", dir: fisheyeAppDir, fork: true, spawn: true) {
            arg(line: "run --debug")
            jvmarg(line: jvmArgs)
        }
        addFisheyeShutdownHook()
        if (!parallel)
        {
            waitForFisheyeToStart()
        }
    }

    String getJvmArgs()
    {
        String jvmArgs = "${mojo.force32bit? "-d32 -server " : ""}" + 
                         "-Xmx512m -XX:MaxPermSize=256m  -Dstudio.home=${mojo.studioHome} -Dfisheye.inst=${mojo.fisheyeHome} ${mojo.fisheyePluginResourceDirectories} ${devMode} " +
					     "-Dstudio.initial.data.properties=${mojo.studioHome}/studio-initial-data.properties " +
                         "-Dstudio.initial.data.xml=${mojo.studioHome}/studio-initial-data.xml " +
                         "${mojo.halInstanceUriJvmArg} " +
                         "${mojo.jvmArgs?:''}";

        return jvmArgs
    }

    private String getDevMode()
    {
        mojo.debug ? "-Dfisheye.dev.mode=true -Datlassian.dev.mode=true -Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=${mojo.fisheyeSuspend ? 'y' : 'n'},address=${mojo.fisheyeDebugPort}" : ""
    }

    public void stop()
    {
        runRemoteFishEyeCommand("stop")
    }

    private void runRemoteFishEyeCommand(String command)
    {
        try
        {
            Socket s = new Socket("localhost", mojo.fisheyeControlPort)
            OutputStream out = s.getOutputStream()
            String cmd = "cenqua\r\n" + command.replaceAll("\\s", "\r\n") + "\r\n"
            out.write(cmd.getBytes())
            out.flush()
            s.shutdownOutput()
        }
        catch (Exception e)
        {
            mojo.log.info("Error shutting down fisheye: ${e.message}")
        }
    }

    private void addFisheyeShutdownHook()
    {
        addShutdownHook {stop()}
    }

    public void waitForFisheyeToStart()
    {
        boolean started = false
        long end = System.currentTimeMillis() + FISHEYE_START_TIMEOUT
        while (!started && System.currentTimeMillis() < end)
        {
            Socket s = null;
            try
            {
                // Wait until we are able to make a successful HTTP connection on fisheye
                s = new Socket()
                s.connect(new InetSocketAddress("localhost", mojo.fisheyeHttpPort), 1000)
                Thread.sleep(10000)	//wait some more
                started = true
            }
            catch (Exception e)
            {
                Thread.sleep(1000)
            }
            finally
            {
                if (s != null && s.isConnected())
                {
                    s.close()
                }
            }
        }
        if (!started)
        {
            throw new RuntimeException("FishEye is not started")
        }
    }

    String toString()
    {
        "Fisheye"
    }

}