package com.atlassian.maven.plugins.studio.util

import com.atlassian.maven.plugins.studio.AbstractFireballMojo

public class CrowdApplication extends AbstractTomcatApplication{

    def CrowdApplication(AbstractFireballMojo mojo)
    {
        this.mojo = mojo
        httpPort = mojo.crowdHttpPort
        rmiPort = mojo.crowdRmiPort
        debugPort = mojo.crowdDebugPort
        debugSuspend = mojo.crowdSuspend        
        webAppName = "crowd"
        contextPath = mojo.crowdContextPath
        warDirectory = mojo.crowdExplodedWarDirectory
        homeDirectory = mojo.crowdHome
        baseUrl = mojo.getBaseUrl("crowd")
    }

    protected String getJvmArgs()
    {
        return "${mojo.crowdJvmArgsExtra} ${mojo.halInstanceUriJvmArg}"
    }

    protected String getDatasource()
    {
        return "cargo.datasource.url=jdbc:hsqldb:${mojo.crowdHome}/database|cargo.datasource.driver=org.hsqldb.jdbcDriver|cargo.datasource.username=sa|cargo.datasource.password=|cargo.datasource.type=javax.sql.DataSource|cargo.datasource.jndi=jdbc/DefaultDS";
    }

    String toString()
    {
        "Crowd"
    }

}