package com.atlassian.maven.plugins.studio.util

import org.apache.tools.ant.DefaultLogger
import org.apache.tools.ant.BuildEvent
import org.apache.tools.ant.Task
import org.apache.tools.ant.Project

/**
 * Builds up the message log for each ant task
 * which can then be retreived by passing in the task
 */
class AntTaskListener extends DefaultLogger {

  Map<Task, String> taskMessages = new HashMap<Task, String>()

  /**
   * Gets the message log for a given Task.
   * @param task The task to return the message log for
   * @return The message or null if the task doesn't exist
   */
  String getTaskMessage(Task task) {
    if(taskMessages.containsKey(task))
    {
      return taskMessages.get(task)
    }
    else
    {
      return null
    }
  }

  /**
   * Extracts the message from the event and adds
   * it to the taskMessages for the specific task
   * @param event The event logged
   */
  void messageLogged(BuildEvent event)
  {
    super.messageLogged(event);

    //Ignore any events higher than INFO. ie DEBUG
    if(event.getPriority() <= Project.MSG_INFO)
    {
      Task task = event.task
      if(taskMessages.containsKey(task))
      {
        taskMessages.put(task, taskMessages.get(task) + '\n' + event.getMessage())
      }
      else
      {
        taskMessages.put(task, event.getMessage())
      }
    }
  }
}
