package com.atlassian.maven.plugins.studio.scm

import org.apache.maven.enforcer.rule.api.EnforcerRule
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;

public class ScmEnforcerRule implements EnforcerRule
{
    private String enforceUrl

    void execute(EnforcerRuleHelper helper)
    {
        def scmConnection = helper.evaluate("\${project.scm.connection}")
        def scmDeveloperConnection = helper.evaluate("\${project.scm.developerConnection}")
        def scmUrl = helper.evaluate("\${project.scm.url}")

        [scmConnection, scmDeveloperConnection, scmUrl].every {
            if(!it.contains(enforceUrl)) {
                throw new EnforcerRuleException("Please check your <scm> paths - " + it + " doesn't contain " + enforceUrl)
            }
        }
    }

    boolean isCacheable()
    {
        false
    }

    boolean isResultValid(EnforcerRule enforcerRule)
    {
        false
    }

    String getCacheId()
    {
        enforceUrl
    }
}
