package com.atlassian.maven.plugins.studio.prepare

import com.atlassian.maven.plugins.studio.util.BuildUtils
import org.apache.maven.artifact.versioning.ArtifactVersion
import org.apache.maven.artifact.versioning.DefaultArtifactVersion

 /**
 * Prepares JIRA for development and functional tests, replacing tokens and configuration files in the WAR, and
 * preparing the JIRA home directory.
 *
 * @goal prepare-jira
 */
public class PrepareJiraMojo extends AbstractPrepareFireballMojo {
    static final ArtifactVersion JIRA_4_1 = new DefaultArtifactVersion("4.1")

    /**
     * The directory that contains the source for overriding files in the JIRA webapp
     *
     * @parameter expression="${jira.webapp.data}" default-value="src/test/resources/webapp/jira"
     */
    String jiraWebAppData


    /**
     * The directory that contains the source for the JIRA home directory
     *
     * @parameter expression="${jira.home.data}" default-value="src/test/resources/home/jira-home"
     */
    String jiraHomeData

    /**
     * @parameter expression="${jira.version}"
     */
    String jiraVersion
    
    /**
     * @parameter expression="${jira.data.version}"
     */
    String jiraDataVersion

    public void execute()
    {
        if (skip) {
            log.info("JIRA prepare has been skipped as maven.test.it.skip has been specified")
            return;
        }

        // copy files to jira home directory if they exist
        File jiraHomeDataDirectory = new File("${project.basedir}/${jiraHomeData}")
        if (jiraHomeDataDirectory.exists()) {
            ant.copyWithPerms(todir: jiraHome) {
                fileset(dir: "${project.basedir}/${jiraHomeData}")
            }
        }
        
        // Replace tokens in JIRA import
        ant.replace(dir: "${jiraHome}/import") {
            replacefilter(token:"%JIRA-HOME%", value:jiraHome)
        }        

        // copy test files to JIRA webapp
        String jiraWar = "${explodedDirectory}/${jiraExplodedWarDirectory}"
        ant.copyWithPerms(todir: jiraWar, overwrite: true) {
            fileset(dir: "${project.basedir}/${jiraWebAppData}")
        }
        // change database to hsql
        ant.replace(file: "${jiraWar}/WEB-INF/classes/entityengine.xml") {
            replacefilter(token: "field-type-name=\"postgres72\"", value: "field-type-name=\"hsql\"")
            replacefilter(token: "schema-name=\"public\"", value: "schema-name=\"PUBLIC\"")
        }

        // allow xml restore
        // Since the patch from JRA-21004 has been applied, we need to set jira.paths.set.allowed to true so that xml
        // restore is enabled.
        // TODO should check to see if the property exists and replace if it does
        if(BuildUtils.isStudioBuild(project))
        {
          ant.echo(file: "${jiraWar}/WEB-INF/classes/jira-application.properties", append: "yes",
                  message: "\njira.paths.set.allowed=true")
        }

        // experimental, may require ant optional task PropertyFile which may not be available on some systems
        // not tested yet
//        ant.propertyFile(file: "${jiraWar}/WEB-INF/classes/jira-application.properties",
//                         comment: "Original file modified by " + this.getClass().getName()) {
//            entry(key: "jira.paths.set.allowed", value: "true", default: "true")
//        }
      if (BuildUtils.isStudioBuild(project))
      {
        parametiseCrowdFile("${jiraWar}/WEB-INF/classes/crowd.properties")
      }

    }

}
