package com.atlassian.maven.plugins.studio.extract

import com.atlassian.maven.plugins.studio.ProductArtifact
import com.atlassian.maven.plugins.studio.util.BuildUtils

/**
 * Extracts the JIRA war into the JIRA directory
 *
 * @goal extract-jira
 */
public class ExtractJiraMojo extends AbstractExtractFireballMojo {

    public ProductArtifact getProductArtifact()
    {
      if (BuildUtils.isStudioBuild(project))
      {
        return new ProductArtifact(groupId: "com.atlassian.studio", artifactId: "studio-jira",
                version: project.version, type: "war");
      }
      else
      {
        return new ProductArtifact(groupId: "com.atlassian.hosted", artifactId: "hosted-jira",
                version: project.version, type: "war")
      }
    }

    public String getProductExplodedDirectory()
    {
        return jiraExplodedWarDirectory;
    }

}