package com.atlassian.maven.plugins.studio.extract

import com.atlassian.maven.plugins.studio.extract.AbstractExtractFireballMojo
import com.atlassian.maven.plugins.studio.ProductArtifact

/**
 * Extracts the Crowd war into the fireball directory
 *
 * @goal extract-crowd
 */
public class ExtractCrowdMojo extends AbstractExtractFireballMojo {

    public ProductArtifact getProductArtifact()
    {
        return new ProductArtifact(groupId: "com.atlassian.studio", artifactId: "studio-crowd", version: project.version, type: "war");
    }

    public String getProductExplodedDirectory()
    {
        return crowdExplodedWarDirectory;
    }

}