package com.atlassian.maven.plugins.studio.extract

import com.atlassian.maven.plugins.studio.extract.AbstractExtractFireballMojo
import com.atlassian.maven.plugins.studio.ProductArtifact
import com.atlassian.maven.plugins.studio.util.BuildUtils

/**
 * Extracts the Confluence war into the fireball directory
 * 
 * @goal extract-confluence
 */
public class ExtractConfluenceMojo extends AbstractExtractFireballMojo {

  /**
   * The maven group id for the Confluence WAR
   *
   * @parameter expression="${confluence.group.id}" default-value="com.atlassian.studio"
   */
  String confluenceGroupId

  /**
   * @parameter expression="${confluence.war.artifact.id}" default-value="studio-confluence"
   */
  String confluenceWarArtifactId

  /**
   * @parameter expression="${confluence.war.version}" default-value="${project.version}"
   */
  String confluenceVersion

    public ProductArtifact getProductArtifact()
    {
      if (BuildUtils.isStudioBuild(project))
      {
        return new ProductArtifact(groupId: confluenceGroupId, artifactId: confluenceWarArtifactId,
                version: confluenceVersion, type: "war");
      }
      else
      {
        return new ProductArtifact(groupId: "com.atlassian.hosted", artifactId: "hosted-confluence",
                version: project.version, type: "war");
      }
    }

    public String getProductExplodedDirectory()
    {
        return confluenceExplodedWarDirectory;
    }
}
