package com.atlassian.maven.plugins.studio.clean

import com.atlassian.maven.plugins.studio.AbstractFireballMojo

public abstract class AbstractCleanFireballMojo extends AbstractFireballMojo {

    /**
     * True if the exploded directory should be deleted
     *
     * @parameter expression="${clean.exploded.dir}" default-value="true"
     */
    boolean cleanExplodedDirectory

    /**
     * True if the home directory should be deleted
     *
     * @parameter expression="${clean.home.dir}" default-value="true"
     */
    boolean cleanHomeDirectory

    public void execute()
    {
        if (cleanExplodedDirectory)
        {
            ant.delete(dir: "${explodedDirectory}/${appExplodedDir}")
        }

        if (cleanHomeDirectory)
        {
            ant.delete(dir: "${homeDirectory}/${appHomeDir}")
        }

    }

    protected abstract String getAppExplodedDir()

    protected abstract String getAppHomeDir()

}