package com.atlassian.maven.plugins.studio.aam

import com.atlassian.maven.plugins.studio.AbstractStudioMojo
import org.apache.commons.httpclient.HttpClient
import org.apache.commons.httpclient.NameValuePair
import org.apache.commons.httpclient.methods.GetMethod
import org.apache.commons.httpclient.methods.MultipartPostMethod
import org.apache.commons.httpclient.methods.multipart.FilePart

/**
 * Mojo used to upload a fireball to the AAM web interface
 *
 * @requiresDependencyResolution runtime
 * @goal upload-fireball
 */
class UploadFireballMojo extends AbstractStudioMojo
{
    /**
     * Username for aam
     * @parameter expression="${aam.username}" default-value="studio"
     */
    String aamUsername;

    /**
     * Password for aam
     * @parameter expression="${aam.password}" default-value=""
     */
    String aamPassword;

    /**
     * User Id for aam, can be found on the upload jar form
     * @parameter expression="${aam.userId}" default-value=""
     */
    String aamUserId;

    void execute()
    {
        final String file = "${project.build.finalName}.zip"
        final String zip = "$project.build.directory/${file}"

        HttpClient client = new HttpClient();

        log.info("Uploading fireball: ${zip}");

        // login
        // curl --cookie-jar ${COOKIEFILE} -d "targetUri=/" -d "username=`urlencode ${USERNAME}`"
        //  -d "password=`urlencode ${PASSWORD}`" -d "_rememberMe=" -d "rememberMe=on"
        //  https://aam.contegix.com/auth/signIn
        log.info("Login as ${aamUsername}")
        GetMethod loginRequest = new GetMethod("https://aam.contegix.com/auth/signIn");
        loginRequest.setQueryString([
                new NameValuePair("targetUri", "/"),
                new NameValuePair("username", aamUsername),
                new NameValuePair("password", aamPassword),
                new NameValuePair("_rememberMe", ""),
                new NameValuePair("rememberMe", "on"),
        ] as NameValuePair[]);
        client.executeMethod(loginRequest); // even if the login fails it will still return a 200

        GetMethod loginCheck = new GetMethod("https://aam.contegix.com/uploadedJar/create");
        loginCheck.setFollowRedirects(false)
        def loginCheckResult = client.executeMethod(loginCheck)
        if (loginCheckResult != 200)
            throw new RuntimeException("Login failed for username/password: ${aamUsername}/${aamPassword}")
        log.info("Login successful")

        // upload
        // curl -L --cookie ${COOKIEFILE} https://aam.contegix.com/uploadedJar/save
        //  -F "user.id=2" -F "fileData_1=@${zipfile};filename=${zipfile}"
        log.debug("Upload fireball")
        MultipartPostMethod uploadRequest = new MultipartPostMethod("https://aam.contegix.com/uploadedJar/save");
        uploadRequest.addParameter("user.id",aamUserId)
        uploadRequest.addPart(new FilePart(file, new ProgressFilePartSource(log, file, new File(zip)), "application/zip", "utf-8"));
        client.executeMethod(uploadRequest);
    }

}
