package com.atlassian.maven.plugins.studio.aam;

import org.apache.maven.plugin.logging.Log;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;

/**
 * Keep's track of the progress of the fireball upload by recording how much of the file
 * has been read.
 */
public class ProgressInputStream extends InputStream
{
    private static final DecimalFormat FMT_SIZE = new DecimalFormat("###'k'");
    private static final DecimalFormat FMT_PERC = new DecimalFormat("#0.00'%'");

    private long count = 0;
    private long step = 102400; // print a message every 'step' bytes
    private long updateTime = 2000; // don't update more often than 'updateTime' ms
    private long lastUpdate = 0;

    private long nextStep = 0;
    private Log log;
    private long length = 0;
    private InputStream inputStream;

    ProgressInputStream(Log log, long length, InputStream inputStream)
    {
        this.log = log;
        this.length = length;
        this.inputStream = inputStream;
    }

    private void update() {
        long time = System.currentTimeMillis();
        if(count>nextStep && lastUpdate<time) {
            nextStep = nextStep+step;
            lastUpdate = time+updateTime;
            log.info(k(count)+"/"+k(length) + " "+FMT_PERC.format(((double)count*100)/length));
        }
    }

    private String k(long n) {
        return FMT_SIZE.format(n / 1024);
    }

    public int read() throws IOException
    {
        int ch = inputStream.read();
        count++;
        update();
        return ch;
    }

    public int read(byte[] b) throws IOException
    {
        int read = inputStream.read(b);
        count += read;
        update();
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException
    {
        int read = inputStream.read(b, off, len);
        count += read;
        update();
        return read;
    }

    @Override
    public long skip(long n) throws IOException
    {
        long skipped = inputStream.skip(n);
        count+=skipped;
        update();
        return skipped;
    }

}