package com.atlassian.maven.plugins.studio

import com.atlassian.maven.plugins.studio.util.FisheyeApplication
import static org.twdata.maven.mojoexecutor.MojoExecutor.*
import com.atlassian.maven.plugins.studio.util.BuildUtils

/**
 * The purpose of this goal is to wait for input and then exit if in debug mode, shutting down fisheye as we go
 *
 * @goal setup-studio
 */
public class SetupStudioMojo extends AbstractFireballMojo
{

    /**
     * The test to run to setup studio
     *
     * @parameter expression="${test}" default-value="TestNothing"
     */
    String setupTestName

    public void execute()
    {
        if (debug && !skip)
        {
            if (BuildUtils.isStudioBuild(project))
            {
              FisheyeApplication fisheye = new FisheyeApplication(this)
              // Wait until fisheye has started up
              fisheye.waitForFisheyeToStart()
            }


            // Execute a test (TestNothing) to set data up
            executeMojo(surefirePlugin, goal('test'),
                    configuration(
                            element(name("skip"), false.toString()),
                            element(name("test"), setupTestName)
                    ),
                    executionEnvironment(project, session, pluginManager))

            if (wait)
            {
                // Wait for user input
                log.info("Studio setup successful!!  Press enter to shutdown.");
                try
                {
                    System.in.read();
                }
                catch (Exception e)
                {
                    // Ignore
                }
                // Exit
                System.exit(0)
            }
        }
        else
        {
            log.info("Studio setup has been skipped as maven.test.it.skip has been specified or studio.debug has not been specified")
        }
    }
}