package com.atlassian.maven.plugins.studio

/**
 * @goal process-fireball-resources
 */
public class ProcessFireballResourcesMojo extends AbstractFireballMojo
{

    /**
     * The directory containing the fireball resources
     *
     * @parameter expression="${fireball.resource.dir}" default-value="${basedir}/src/main/fireball"
     */
    String fireballResources

    public void execute()
    {
        ant.copyWithPerms(todir: explodedDirectory) {
            fileset(dir: fireballResources)
        }
        ant.replace(file: "${explodedDirectory}/version.properties") {
            replacefilter(token: "%BUILD_NUMBER%", value: project.properties.getProperty("buildNumber"))
            replacefilter(token: "%VERSION%", value: project.getVersion())
        }
    }

}