package com.atlassian.maven.plugins.studio

import org.apache.maven.project.MavenProject
import org.apache.maven.model.Plugin
import static org.twdata.maven.mojoexecutor.MojoExecutor.*
import org.apache.maven.execution.MavenSession
import org.apache.maven.plugin.PluginManager
import org.apache.maven.profiles.ProfileManager
import org.apache.maven.profiles.DefaultProfileManager
import org.apache.maven.execution.MavenExecutionRequest
import org.apache.maven.execution.DefaultMavenExecutionRequest
import org.apache.maven.Maven

/**
 * @requiresDependencyResolution runtime
 * @goal pdkinstall
 */
public class PdkInstall extends AbstractStudioMojo
{

    final Plugin atlassianPdk = plugin(
            groupId('com.atlassian.maven.plugins'),
            artifactId('atlassian-pdk'),
            version('2.1.6'))

    /**
     * The apps this project should be installed to
     *
     * @parameter expression="${studio.pdk.apps}"
     */
    private String pdkApps

    /**
     * Used to limit which apps should be deployed to
     *
     * @parameter expression="${studio.deploy.to}"
     */
    private String deployToApps
    
    /**
     * Username used to upload
     *
     * @parameter expression="${studio.pdk.username}" default-value="sysadmin"
     */
    private String username
    
    /**
     * Password used to upload
     *
     * @parameter expression="${studio.pdk.password}" default-value="sysadmin"
     */
    private String password
    
    public void execute()
    {
        if (project.packaging == "studio-war" || project.packaging == "studio-fireball")
        {
            // Don't do anything, the reactor should have found all its dependencies
        }
        else if (pdkApps != null)
        {
            Set<String> appsToDeploy = new HashSet<String>()
            appsToDeploy.addAll(Arrays.asList(pdkApps.split(",")))
            if (deployToApps != null)
            {
                appsToDeploy.retainAll(Arrays.asList(deployToApps.split(",")))
            }
            // Build and install it
            if (!appsToDeploy.empty)
            {
                build()
                install(appsToDeploy)
            }
        }
        else
        {
            build()
        }
    }

    private void build()
    {
        try
        {
            session.setCurrentProject(project)
            session.executionProperties.put("maven.test.skip", "true")
            ProfileManager profileManager = new DefaultProfileManager(session.container)
            MavenExecutionRequest request = new DefaultMavenExecutionRequest(
                    session.localRepository, session.settings,
                    session.eventDispatcher, Arrays.asList("install"),
                    new File(System.getProperty("user.dir")).path,
                    profileManager, session.executionProperties,
                    project.properties, true)
            request.recursive = false
            request.pomFile = new File(project.basedir, "pom.xml").path
            ((Maven) session.lookup(Maven.ROLE)).execute(request)
        }
        finally
        {

        }
    }

    private void install(Set<String> appsToDeploy)
    {
        for (String app: appsToDeploy)
        {
            executeMojo(atlassianPdk, "install",
                    configuration(
                            element("serverUrl", getBaseUrl(app)),
                            element("username", username),
                            element("password", password)
                    ),
                    executionEnvironment(project, session, pluginManager))
        }
    }

    private boolean isPlugins2Plugin()
    {
        if (project.packaging == "bundle")
        {
            return true
        }
        else if (project.packaging == "jar")
        {
            File atlassianPlugins = new File(project.basedir, "src/main/resources/atlassian-plugin.xml")
            if (atlassianPlugins.exists())
            {
                return atlassianPlugins.text.contains("pluginsVersion=\"2\"")
            }
        }
        return false;
    }

}