package com.atlassian.maven.plugins.studio

import com.atlassian.maven.plugins.studio.AbstractFireballMojo
import static org.twdata.maven.mojoexecutor.MojoExecutor.*
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager

/**
 * @requiresDependencyResolution runtime
 * @goal package-fireball
 */
class PackageFireballMojo extends AbstractFireballMojo
{
  /**
   * Directory for the exploded war
   *
   * @parameter expression="${fireball.utility.dir}" default-value="utils"
   * @required
   */
  String fireballUtilityDir;


    /**
     * @component
     * @required
     * @readonly
     */
    ArtifactHandlerManager artifactHandlerManager;

    void execute()
    {
      
        def artifacts = project.dependencyArtifacts;

        def fireballUtilities = artifacts.findAll {it.scope == 'fireball-utility'}

        if (fireballUtilities) {
            ant.mkdir(dir: "$explodedDirectory/$fireballUtilityDir")

            fireballUtilities.each { dependency ->
                ant.copyWithPerms(todir: "$explodedDirectory/$fireballUtilityDir", overwrite: true) {
                  fileset(dir: dependency.file.parent, includes:dependency.file.name)
                }
            }
        }

        if (!skipPackage)
        {
            final String zip = "$project.build.directory/${project.build.finalName}.zip"
            ant.zipWithPerms(destfile: zip) {
                zipfileset(dir: explodedDirectory)
            }
            project.artifact.setFile(new File(zip))
            project.artifact.setArtifactHandler(artifactHandlerManager.getArtifactHandler("zip"))
        }
    }
}