package com.atlassian.maven.plugins.studio

import com.atlassian.maven.plugins.studio.util.AntTaskListener

import org.apache.maven.execution.MavenSession
import org.apache.maven.model.Dependency
import org.apache.maven.model.Plugin
import org.apache.maven.plugin.PluginManager
import org.apache.maven.project.MavenProject
import org.apache.maven.project.MavenProjectHelper
import org.codehaus.gmaven.mojo.GroovyMojo

import static org.twdata.maven.mojoexecutor.MojoExecutor.*

/**
 * The root of all mojos of this maven plugin. This is mainly to share some configuration parameters and components.
 */
abstract class AbstractStudioMojo extends GroovyMojo
{
    final Plugin dependencyPlugin = plugin(
            groupId('org.apache.maven.plugins'),
            artifactId('maven-dependency-plugin'))

    final Plugin cargoPlugin = plugin(
            groupId('org.codehaus.cargo'),
            artifactId('cargo-maven2-plugin'))

    final Plugin surefirePlugin = plugin(
            groupId('org.apache.maven.plugins'),
            artifactId('maven-surefire-plugin'))

    final AntTaskListener antTaskListener = new AntTaskListener()

    /**
     * The Maven Projectpom
     *
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    MavenProject project

    /**
     * The Maven Session
     *
     * @parameter expression="${session}"
     * @required
     * @readonly
     */
    MavenSession session

    /**
     * The Maven PluginManager
     *
     * @component
     * @required
     * @readonly
     */
    PluginManager pluginManager

    /**
     * Maven ProjectHelper.
     *
     * @component
     * @required
     * @readonly
     */
    MavenProjectHelper projectHelper  
    
    /**
    * @parameter expression="${studio.host}" default-value="localhost"
    */
    String studioHost

    /**
     * Get the base URL of the app
     */
    public String getBaseUrl(String app)
    {
        int httpPort = AbstractStudioMojo.getField("${app}HttpPort").getInt(this)
        String contextPath = (String) AbstractStudioMojo.getField("${app}ContextPath").get(this)
        if (contextPath != null && contextPath.length() > 0)
        {
            return "http://${studioHost}:${httpPort}/${contextPath}"
        }
        else
        {
            return "http://${studioHost}:${httpPort}"
        }
    }



    /**
     * Whether the package stage should be skipped
     *
     * @parameter expression="${studio.package.skip}" default-value="false"
     */
    boolean skipPackage

    /**
     * The Crowd HTTP port
     *
     * @parameter expression="${crowd.http.port}" default-value="4990"
     */
    public int crowdHttpPort

    /**
     * The Crowd RMI port
     *
     * @parameter expression="${crowd.rmi.port}" default-value="49901"
     */
    int crowdRmiPort

    /**
     * The Crowd debug port
     *
     * @parameter expression="${crowd.debug.port}" default-value="5003"
     */
    int crowdDebugPort

    /**
     * The Crowd context path
     *
     * @parameter expression="${crowd.context.path}" default-value="crowd"
     */
    public String crowdContextPath

    /**
     * The Confluence HTTP port
     *
     * @parameter expression="${confluence.http.port}" default-value="1990"
     */
    public int confluenceHttpPort

    /**
     * The Confluence RMI port
     *
     * @parameter expression="${confluence.rmi.port}" default-value="19901"
     */
    int confluenceRmiPort

    /**
     * The Confluence debug port
     *
     * @parameter expression="${confluence.debug.port}" default-value="5007"
     */
    int confluenceDebugPort

    /**
     * The Confluence context path
     *
     * @parameter expression="${confluence.context.path}" default-value="wiki"
     */
    public String confluenceContextPath

    /**
     * The JIRA HTTP port
     *
     * @parameter expression="${jira.http.port}" default-value="2990"
     */
    public int jiraHttpPort

    /**
     * The JIRA RMI port
     *
     * @parameter expression="${jira.rmi.port}" default-value="29901"
     */
    int jiraRmiPort

    /**
     * The JIRA debug port
     *
     * @parameter expression="${jira.debug.port}" default-value="5009"
     */
    int jiraDebugPort

    /**
     * The JIRA context path
     *
     * @parameter expression="${jira.context.path}" default-value="jira"
     */
    public String jiraContextPath

    /**
     * The FishEye HTTP port
     *
     * @parameter expression="${fisheye.http.port}" default-value="3990"
     */
    public int fisheyeHttpPort

    /**
     * The FishEye Control port
     *
     * @parameter expression="${fisheye.control.port}" default-value="39901"
     */
    int fisheyeControlPort

    /**
     * The FishEye debug port
     *
     * @parameter expression="${fisheye.debug.port}" default-value="5005"
     */
    int fisheyeDebugPort

    /**
     * The FishEye context path
     *
     * @parameter expression="${fisheye.context.path}" default-value=""
     */
    public String fisheyeContextPath

    /**
     * The Bamboo HTTP port
     *
     * @parameter expression="${bamboo.http.port}" default-value="6990"
     */
    public int bambooHttpPort

    /**
     * The Bamboo RMI port
     *
     * @parameter expression="${bamboo.rmi.port}" default-value="16990"
     */
    int bambooRmiPort

    /**
     * The Bamboo debug port
     *
     * @parameter expression="${bamboo.debug.port}" default-value="5011"
     */
    int bambooDebugPort

    /**
     * The Bamboo context path
     *
     * @parameter expression="${bamboo.context.path}" default-value="builds"
     */
    public String bambooContextPath

    /**
     * Whether Google Apps is enabled
     *
     * @parameter expression="${gapps.enabled}" default-value="false"
     */
    boolean gappsEnabled

    /**
     * If gappsEnabled is true, this will contain the domain name of the gapps - used during testing only
     *
     * @parameter expression="${com.atlassian.agmp.domain.name}" default-value="atl-paid-dev.com"
     */
    String gappsDomain
    
    public AbstractStudioMojo()
    {
        // Intercept calls to original Copy & Zip tasks to issue a warning.
        // Could be used to automatically invoke an improved copy command.
        AntBuilder.metaClass.copy = {Object... args ->
            log.warn("Using Ant's copy task, which does not preserve Unix file permissions.")
            delegate.invokeMethod("copy", args[0])
        }
        AntBuilder.metaClass.zip = {Object... args ->
            log.warn("Using Ant's zip task, which does not preserve Unix file permissions.")
            delegate.invokeMethod("zip", args[0])
        }
        
        ant.taskdef(name: "zipWithPerms", classname: "com.atlassian.ant.tasks.ZipWithPerms")
        ant.taskdef(name: "copyWithPerms", classname: "com.atlassian.ant.tasks.CopyWithPerms")
    }

    public static Dependency dependency(String groupId, String artifactId, String version)
    {
        Dependency dep = new Dependency()
        dep.groupId = groupId
        dep.artifactId = artifactId
        dep.version = version
        return dep
    }

    public static Plugin plugin(String groupId, String artifactId, String version, Dependency... dependencies) {
        Plugin plugin = plugin(groupId, artifactId, version)
        plugin.dependencies = Arrays.asList(dependencies)
        return plugin
    }


}