package com.atlassian.maven.plugins.studio.util

import com.atlassian.maven.plugins.studio.AbstractFireballMojo

public class ConfluenceApplication extends AbstractTomcatApplication{

    def ConfluenceApplication(AbstractFireballMojo mojo)
    {
        this.mojo = mojo
        httpPort = mojo.confluenceHttpPort
        rmiPort = mojo.confluenceRmiPort
        debugPort = mojo.confluenceDebugPort
        debugSuspend = mojo.confluenceSuspend
        webAppName = "confluence"
        contextPath = mojo.confluenceContextPath
        warDirectory = mojo.confluenceExplodedWarDirectory
        homeDirectory = mojo.confluenceHome
        baseUrl = mojo.getBaseUrl("confluence")
    }

    protected String getJvmArgs()
    {
        return "-Xmx512m -XX:MaxPermSize=256m ${devMode} ${mojo.confJvmArgsExtra} ${mojo.confluencePluginResourceDirectories}"
    }

    private String getDevMode()
    {
        mojo.debug ? "-Dconfluence.dev.mode=true -Datlassian.dev.mode=true" : ""
    }

    protected String getDatasource()
    {
        // Note, this must be the database, otherwise, CONF-20739 will hurt you
        return "cargo.datasource.url=jdbc:hsqldb:${mojo.confluenceHome}/database/confluencedb|cargo.datasource.driver=org.hsqldb.jdbcDriver|cargo.datasource.username=sa|cargo.datasource.password=|cargo.datasource.type=javax.sql.DataSource|cargo.datasource.jndi=jdbc/DefaultDS";
    }

    String toString()
    {
        "Confluence"
    }
}