package com.atlassian.maven.plugins.studio.util

import com.atlassian.maven.plugins.studio.AbstractFireballMojo

public class BambooApplication extends AbstractTomcatApplication {

    def BambooApplication(AbstractFireballMojo mojo)
    {
        this.mojo = mojo
        httpPort = mojo.bambooHttpPort
        rmiPort = mojo.bambooRmiPort
        debugPort = mojo.bambooDebugPort
        debugSuspend = mojo.bambooSuspend
        webAppName = "bamboo"
        contextPath = mojo.bambooContextPath
        warDirectory = mojo.bambooExplodedWarDirectory
        homeDirectory = mojo.bambooHome
        baseUrl = mojo.getBaseUrl("bamboo")
    }

    public void start(boolean parallel)
    {
        if (mojo.bambooEnabled)
        {
            super.start(parallel)
        }
    }

    public void stop()
    {
        if (mojo.bambooEnabled)
        {
            super.stop()
        }
    }

    protected String getJvmArgs()
    {
        return "-Xmx512m -XX:MaxPermSize=256m ${devMode} -Dfunctestmode=true -Dbamboo.jms.broker.uri=tcp://localhost:20666 ${mojo.bambooPluginResourceDirectories}"
    }

    // Bamboo doesn't seem to have it's own dev mode flag but added it incase they add it in the
    // future. Plugins will still look at the atlassian.dev.mode flag.
    private String getDevMode()
    {
        mojo.debug ? "-Dbamboo.dev.mode=true -Datlassian.dev.mode=true" : ""
    }

    protected String getDatasource()
    {
        return "cargo.datasource.url=jdbc:hsqldb:${mojo.bambooHome}/database|cargo.datasource.driver=org.hsqldb.jdbcDriver|cargo.datasource.username=sa|cargo.datasource.password=|cargo.datasource.type=javax.sql.DataSource|cargo.datasource.jndi=jdbc/DefaultDS";
    }

    String toString()
    {
        "Bamboo"
    }

}