package com.atlassian.maven.plugins.studio.start

import com.atlassian.maven.plugins.studio.util.Application
import com.atlassian.maven.plugins.studio.AbstractFireballMojo

abstract class AbstractStartFireballMojo extends AbstractFireballMojo {

    /**
     * Whether the app should be started as a daemon, implies wait is false
     *
     * @parameter expression="${studio.daemon.mode}" default-value="false"
     *
     */
    boolean daemon

    /**
     * Whether start up of containers should be done in parallel
     *
     * @parameter expression="${studio.parallel.startup}" default-value="false"
     */
    boolean parallelStartup

    protected abstract Application getApplication()

    public void execute()
    {
        if (skip)
            log.info("Application ${application} start has been skipped as maven.test.skip has been specified")
        else
            application.start(parallelStartup)
    }

}