package com.atlassian.maven.plugins.studio.prepare

 /**
 * Prepares FishEye for development and functional tests, replacing tokens and configuration files in the app, and
 * preparing the FishEye home directory.
 *
 * @goal prepare-fisheye
 */
public class PrepareFisheyeMojo  extends AbstractPrepareFireballMojo {

    /**
     * The directory that contains the source for overriding files in the FishEye webapp
     *
     * @parameter expression="${fisheye.webapp.data}" default-value="src/test/resources/webapp/fisheye"
     */
    String fisheyeWebAppData


    /**
     * The directory that contains the source for the fisheye home directory
     *
     * @parameter expression="${fisheye.home.data}" default-value="src/test/resources/home/fisheye-home"
     */
    String fisheyeHomeData

    /**
     * @parameter expression="${fisheye.data.version}"
     */
    String fisheyeDataVersion

    public void execute()
    {
        if (skip) {
            log.info("FishEye prepare has been skipped as maven.test.skip has been specified")
            return;
        }
        // copy files to fisheye home directory
        ant.copyWithPerms(todir: fisheyeHome) {
            fileset(dir: "${project.basedir}/${fisheyeHomeData}")
        }
        String license = new File("${studioHomeData}/studio.license").getText()
        // Replace tokens in fisheye config
        ant.replace(file: "${fisheyeHome}/config.xml") {
            replacefilter(token:"%TEST-CONTROL-BIND%", value: fisheyeControlPort)
            replacefilter(token:"%TEST-HTTP-BIND%", value: fisheyeHttpPort)
        }
        // copy test files to fisheye webapp
        String fisheyeWar = "${explodedDirectory}/${fisheyeExplodedDirectory}"
        ant.copyWithPerms(todir: fisheyeWar, overwrite: true) {
            fileset(dir: "${project.basedir}/${fisheyeWebAppData}")
        }

        processGappsBundledPlugins(fisheyeWar, "plugins/bundled-plugins.zip")        
    }

}