package com.atlassian.maven.plugins.studio.prepare

import com.atlassian.maven.plugins.studio.prepare.AbstractPrepareFireballMojo

/**
 * Prepares Crowd for development and functional tests, replacing tokens and configuration files in the WAR, and
 * preparing the Crowd home directory.
 *
 * @goal prepare-crowd
 */
class PrepareCrowdMojo extends AbstractPrepareFireballMojo
{

    /**
     * The directory that contains the source for overriding files in the Crowd webapp
     *
     * @parameter expression="${crowd.webapp.data}" default-value="src/test/resources/webapp/crowd"
     */
    String crowdWebAppData


    /**
     * The directory that contains the source for the Crowd home directory
     *
     * @parameter expression="${crowd.home.data}" default-value="src/test/resources/home/crowd-home"
     */
    String crowdHomeData

    public void execute()
    {

        if (skip) {
            log.info("Crowd prepare has been skipped as maven.test.skip has been specified")
            return;
        }

        //copy files to crowd webapp
        String crowdWar = "${explodedDirectory}/${crowdExplodedWarDirectory}"
        ant.copyWithPerms(todir: crowdWar, overwrite: true) {
            fileset(dir: "${project.basedir}/${crowdWebAppData}")
        }

        parametiseCrowdFile("${crowdWar}/WEB-INF/classes/crowd.properties")

        processGappsBundledPlugins(crowdWar, "WEB-INF/classes/atlassian-bundled-plugins.zip")
        
    }

}
