package com.atlassian.maven.plugins.studio.prepare

import com.atlassian.maven.plugins.studio.util.BuildUtils
import static org.twdata.maven.mojoexecutor.MojoExecutor.configuration
import static org.twdata.maven.mojoexecutor.MojoExecutor.element
import static org.twdata.maven.mojoexecutor.MojoExecutor.executeMojo
import static org.twdata.maven.mojoexecutor.MojoExecutor.executionEnvironment
import static org.twdata.maven.mojoexecutor.MojoExecutor.goal
import static org.twdata.maven.mojoexecutor.MojoExecutor.name

 /**
 * Prepares Confluence for development and functional tests, replacing tokens and configuration files in the WAR, and
 * preparing the Confluence home directory.
 *
 * @goal prepare-confluence
 */
class PrepareConfluenceMojo extends AbstractPrepareFireballMojo
{

    /**
     * The directory that contains the source for overriding files in the Confluence webapp
     *
     * @parameter expression="${confluence.webapp.data}" default-value="src/test/resources/webapp/confluence"
     */
    String confluenceWebAppData


    /**
     * The directory that contains the source for the Confluence home directory
     *
     * @parameter expression="${confluence.home.data}" default-value="src/test/resources/home/confluence-home"
     */
    String confluenceHomeData

    /**
     * The version of Confluence resources that is used for running confluence in development mode
     *
     * @parameter expression="${confluence.data.version}"
     */
    String confluenceDataVersion

    public void execute()
    {
        if (skip) {
            log.info("Confluence prepare has been skipped as maven.test.skip has been specified")
            return;
        }

        String confluenceWar = "${explodedDirectory}/${confluenceExplodedWarDirectory}"
        
        //copy files to confluence webapp
        File webAppData = new File("${project.basedir}/${confluenceWebAppData}")
        if (webAppData.exists())
        {
          ant.copyWithPerms(todir: confluenceWar, overwrite: true) {
              fileset(dir: "${project.basedir}/${confluenceWebAppData}")
          }
        }

        if (BuildUtils.isStudioBuild(project))
        {
          parametiseCrowdFile("${confluenceWar}/WEB-INF/classes/crowd.properties")

          processGappsBundledPlugins(confluenceWar, "WEB-INF/classes/com/atlassian/confluence/setup/atlassian-bundled-plugins.zip")
        }
    }

    private void copyHomeDirectory()
    {
        executeMojo(dependencyPlugin,
                goal("unpack"),
                configuration(
                        element(name("artifactItems"),
                                element(name("artifactItem"),
                                        element(name("groupId"), "com.atlassian.confluence.plugins"),
                                        element(name("artifactId"), "confluence-plugin-test-resources"),
                                        element(name("version"), confluenceDataVersion))),
                        element(name("outputDirectory"), homeDirectory)
                ),
                executionEnvironment(project, session, pluginManager))
    }
}