package com.atlassian.maven.plugins.studio.prepare

import static org.twdata.maven.mojoexecutor.MojoExecutor.*
import com.atlassian.maven.plugins.studio.prepare.AbstractPrepareFireballMojo

/**
 * Prepares Bamboo for development and functional tests, replacing tokens and configuration files in the WAR, and extracting the Bamboo home directory.
 *
 * @goal prepare-bamboo
 */
class PrepareBambooMojo extends AbstractPrepareFireballMojo
{

    /**
     * The directory that contains the source for overriding files in the Bamboo webapp
     *
     * @parameter expression="${bamboo.webapp.data}" default-value="src/test/resources/webapp/bamboo"
     */
    String bambooWebAppData


    /**
     * The directory that contains the source for the Bamboo home directory
     *
     * @parameter expression="${bamboo.home.data}" default-value="src/test/resources/home/bamboo-home"
     */
    String bambooHomeData

    /**
     * The version of Bamboo resources that is used for running bamboo in development mode
     *
     * @parameter expression="${bamboo.data.version}"
     */
    String bambooDataVersion

    public void execute()
    {
        if (skip) {
            log.info("Bamboo prepare has been skipped as maven.test.skip has been specified")
            return;
        }
        // copy bamboo test resources into home directory
        copyHomeDirectory()
        
        // overrite some files in bamboo home directory
        File bambooHomeDataDirectory = new File("${project.basedir}/${bambooHomeData}")
        if (bambooHomeDataDirectory.exists()) {
            ant.copyWithPerms(todir: bambooHome, overwrite:true) {
                fileset(dir: "${project.basedir}/${bambooHomeData}")
            }
        }
        
        // replace @project-dir@ token with ${project.build.directory}
        ant.replace(file:"${bambooHome}/bamboo.cfg.xml", token: "@project-dir@", value: homeDirectory)
        
        //copy files to bamboo webapp
        String bambooWar = "${explodedDirectory}/${bambooExplodedWarDirectory}"
        ant.copyWithPerms(todir: bambooWar, overwrite: true) {
            fileset(dir: "${project.basedir}/${bambooWebAppData}")
        }

        parametiseCrowdFile("${bambooWar}/WEB-INF/classes/crowd.properties")

        processGappsBundledPlugins(bambooWar, "WEB-INF/classes/atlassian-bundled-plugins.zip")
    }

    private void copyHomeDirectory()
    {
        executeMojo(dependencyPlugin,
                goal("unpack"),
                configuration(
                        element(name("artifactItems"),
                                element(name("artifactItem"),
                                        element(name("groupId"), "com.atlassian.bamboo.plugins"),
                                        element(name("artifactId"), "bamboo-plugin-test-resources"),
                                        element(name("version"), bambooDataVersion))),
                        element(name("outputDirectory"), homeDirectory)
                ),
                executionEnvironment(project, session, pluginManager))
    }
}