package com.atlassian.maven.plugins.studio.prepare

import com.atlassian.maven.plugins.studio.AbstractFireballMojo

abstract class AbstractPrepareFireballMojo extends AbstractFireballMojo
{

    protected parametiseCrowdFile(String crowdPropertiesFileName)
    {
        ant.replace(file: crowdPropertiesFileName) {
            replacefilter(token: "%CROWD-INTERNAL-URL%", value: getBaseUrl("crowd"))
            replacefilter(token: "%CROWD-URL%", value: getBaseUrl("crowd"))
        }
    }

    protected processGappsBundledPlugins(String explodedWarDirectory, String bundledPluginsFile)
    {
        if (!gappsEnabled)
        {
            String tmpBundledPlugins = "$explodedWarDirectory/tmp-bundled-plugins.zip"
            String bundledPlugins = "$explodedWarDirectory/$bundledPluginsFile"
            ant.zipWithPerms(destfile: tmpBundledPlugins, compress: false) {
                zipfileset(src: bundledPlugins, excludesfile: "$explodedWarDirectory/$gappsPluginListFileName")
            }
            ant.move(file: tmpBundledPlugins, tofile: bundledPlugins)
        }
    }

}