package com.atlassian.maven.plugins.studio.extract

import com.atlassian.maven.plugins.studio.extract.AbstractExtractFireballMojo
import com.atlassian.maven.plugins.studio.ProductArtifact

/**
 * Extracts the FishEye war into the FishEye directory
 *
 * @goal extract-fisheye
 */
public class ExtractFisheyeMojo extends AbstractExtractFireballMojo {

    public ProductArtifact getProductArtifact()
    {
        return new ProductArtifact(groupId: "com.atlassian.studio", artifactId: "studio-fisheye",
                version: project.version, type: "zip");
    }

    public String getProductExplodedDirectory()
    {
        return fisheyeExplodedDirectory;
    }

}