package com.atlassian.maven.plugins.studio.extract

import com.atlassian.maven.plugins.studio.extract.AbstractExtractFireballMojo
import com.atlassian.maven.plugins.studio.ProductArtifact
import com.atlassian.maven.plugins.studio.util.BuildUtils

/**
 * Extracts the Confluence war into the fireball directory
 * 
 * @goal extract-confluence
 */
public class ExtractConfluenceMojo extends AbstractExtractFireballMojo {

    public ProductArtifact getProductArtifact()
    {
      if (BuildUtils.isStudioBuild(project))
      {
        return new ProductArtifact(groupId: "com.atlassian.studio", artifactId: "studio-confluence",
                version: project.version, type: "war");
      }
      else
      {
        return new ProductArtifact(groupId: "com.atlassian.hosted", artifactId: "hosted-confluence",
                version: project.version, type: "war");
      }
    }

    public String getProductExplodedDirectory()
    {
        return confluenceExplodedWarDirectory;
    }
}
