package com.atlassian.maven.plugins.studio.extract

import com.atlassian.maven.plugins.studio.extract.AbstractExtractFireballMojo
import com.atlassian.maven.plugins.studio.ProductArtifact

/**
 * Extracts the Bamboo war into the fireball directory
 *
 * @goal extract-bamboo
 */
public class ExtractBambooMojo extends AbstractExtractFireballMojo {

    public ProductArtifact getProductArtifact()
    {
        return new ProductArtifact(groupId: "com.atlassian.studio", artifactId: "studio-bamboo",
                version: project.version, type: "war");
    }

    public String getProductExplodedDirectory()
    {
        return bambooExplodedWarDirectory;
    }

}