package com.atlassian.maven.plugins.studio.extract

import static org.twdata.maven.mojoexecutor.MojoExecutor.*
import com.atlassian.maven.plugins.studio.AbstractFireballMojo
import com.atlassian.maven.plugins.studio.ProductArtifact

abstract class AbstractExtractFireballMojo extends AbstractFireballMojo {

    public void execute()
    {
        ProductArtifact artifact = getProductArtifact()

        executeMojo(
                dependencyPlugin,
                goal("unpack-dependencies"),
                configuration(
                        element(name("excludeTransitive"), "true"),
                        element(name("includeGroupIds"), artifact.groupId),
                        element(name("includeArtifactIds"), artifact.artifactId),
                        element(name("includeTypes"), artifact.type),
                        element(name("outputDirectory"), "${explodedDirectory}/${productExplodedDirectory}")
                ),
                executionEnvironment(project, session, pluginManager)
        )

    }

    abstract ProductArtifact getProductArtifact()

    abstract String getProductExplodedDirectory()

}