package com.atlassian.maven.plugins.sandbox.scm;

import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScmHandlerFactory
{
    private ScmHandlerFactory()
    {
    }

    @Nullable
    public static ScmHandler createScmUtils(final Log log, @Nullable final Scm scm) throws MojoFailureException
    {
        if (scm==null)
        {
            //repo interaction was disabled
            return null;
        }
        return newScmHandler(log, scm.getDeveloperConnection());
    }

    @NotNull
    private static ScmHandler newScmHandler(@NotNull Log log, @NotNull String connection) throws MojoFailureException
    {
        final ScmConnectionWrapper wrapper = new ScmConnectionWrapper(connection);
        switch (wrapper.getRepositoryType())
        {
            case ScmConnectionWrapper.RepositoryType.SVN:
                return new SvnHandler(log, connection);
            case ScmConnectionWrapper.RepositoryType.HG:
                return new HgHandler(log);
            case ScmConnectionWrapper.RepositoryType.GIT:
                return new GitHandler(log);
            default:
                throw new MojoFailureException("Unknown repository type " + connection);
        }
    }

    @Nullable
    public static ScmRoHandler createScmRoUtils(@NotNull final Log log, @Nullable final Scm scm) throws MojoFailureException
    {
        if (scm==null)
        {
            //repo interaction was disabled
            return null;
        }
        return newScmHandler(log, scm.getConnection());
    }
}
