package com.atlassian.maven.plugins.sandbox.scm;

import com.atlassian.maven.plugins.sandbox.ScmException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

import java.util.Collection;
import java.util.List;

public class CommandRunner
{
    private final Log log;

    public CommandRunner(final Log log)
    {
        this.log = log;
    }

    public int runCommand(final Collection<String> output, final String... arguments) throws ScmException
    {
        String command = null;
        try
        {
            final ProcessBuilder processBuilder = new ProcessBuilder(arguments);
            processBuilder.redirectErrorStream(true);

            command = StringUtils.join(processBuilder.command(), ' ');
            log.info("Running command: '" + command + "'.");

            final Process process = processBuilder.start();

            final List<String> processOutput = IOUtils.readLines(process.getInputStream());
            output.clear();
            output.addAll(processOutput);
            return process.waitFor();
        }
        catch (Exception e)
        {
            throw new ScmException("An error has occurred when running hg command: " + command, e);
        }
    }
}
