package com.atlassian.maven.plugins.sandbox;

import org.apache.commons.lang.StringUtils;

import java.util.Collection;

public class ScmException extends Exception
{
    public ScmException(final String msg, final Exception e)
    {
        super(msg, e);
    }

    public ScmException(final String msg)
    {
        super(msg);
    }

    public ScmException(final String msg, final int exitCode, final Collection<String> output)
    {
        super(msg + ", exit code: " + exitCode +", output:\n" + StringUtils.join(output, "\n"));
    }
}