package com.atlassian.maven.plugins.sandbox;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

import static org.twdata.maven.mojoexecutor.MojoExecutor.configuration;
import static org.twdata.maven.mojoexecutor.MojoExecutor.executeMojo;
import static org.twdata.maven.mojoexecutor.MojoExecutor.executionEnvironment;
import static org.twdata.maven.mojoexecutor.MojoExecutor.goal;

/**
 * @goal rollback
 * @requiresProject false
 */
public class RollbackMojo extends AbstractSandboxMojo
{
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException
    {
        checkSandboxKeySpecified();

        executeMojo(RELEASE_PLUGIN,
                    goal("rollback"),
                    configuration(),
                    executionEnvironment(
                        getProject(),
                        getSession(),
                        getBuildPluginManager()
                    ));
    }
}
