package com.atlassian.maven.plugins.sandbox;

import com.atlassian.sandbox.promotion.api.SandboxService;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

import java.util.Map;
import java.util.TreeMap;

/**
 * List properties stored against a sandbox
 * @goal list-properties
 * @requiresProject false
 */
public class ListPropertiesMojo extends AbstractSandboxMojo
{
    public void execute() throws MojoExecutionException, MojoFailureException
    {
        SandboxService sandboxService = getSandboxService();

        Map<String,String> properties = sandboxService.getProperties(getSandboxKey());
        if (properties != null && !properties.isEmpty())
        {
            getLog().info("Found " + properties.size() + " properties for '" + getSandboxKey() + "'");
            Map<String, String> sortedProperties = new TreeMap<String, String>(properties);
            for (Map.Entry<String, String> entry : sortedProperties.entrySet())
            {
                getLog().info(entry.getKey() + ":" + entry.getValue());
            }
        }
        else
        {
            getLog().info("No properties found for '" + getSandboxKey() + "'");
        }
    }
}
