package com.atlassian.maven.plugins.sandbox;

import com.atlassian.sandbox.promotion.api.Resource;
import com.atlassian.sandbox.promotion.api.SandboxService;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Server;

import java.util.Collection;

/**
 * List available Sandboxes
 * @goal list
 * @requiresProject false
 */
public class ListMojo extends AbstractSandboxMojo
{
    // ------------------------------------------------------------------------------------------------------- Constants
    // ------------------------------------------------------------------------------------------------- Type Properties
    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors
    // ----------------------------------------------------------------------------------------------- Interface Methods
    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods

    public void execute() throws MojoExecutionException, MojoFailureException
    {
        SandboxService sandboxService = getSandboxService();

        Server server = getServer();

        getLog().info("Listing available Sandboxes at " + getSandboxRepositoryRootUrl() + ":");
        Collection<Resource> resources = sandboxService.listSandboxes(server.getUsername(), decryptPasswordIfNecessary(server.getPassword()), getSandboxRepositoryRootUrl());

        int count = 0;
        for (Resource resource : resources)
        {
            count++;
            getLog().info(count + ") " + resource.getName());
        }

        getLog().info("There are " + count + " sandboxes.");
    }


    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators
}
