package com.atlassian.maven.plugins.sandbox;

import com.atlassian.sandbox.promotion.api.SandboxService;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Server;

/**
 * Deletes the specified Sandbox
 * @goal delete
 * @requiresProject false
 */
public class DeleteMojo extends AbstractSandboxMojo
{
    // ------------------------------------------------------------------------------------------------------- Constants
    // ------------------------------------------------------------------------------------------------- Type Properties
    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors
    // ----------------------------------------------------------------------------------------------- Interface Methods
    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods

    public void execute() throws MojoExecutionException, MojoFailureException
    {
        SandboxService sandboxService = getSandboxService();

        Server server = getServer();

        checkSandboxKeySpecified();

        String password = decryptPasswordIfNecessary(server.getPassword());

        if (!sandboxService.exists(getSandboxKey(), server.getUsername(), password, getSandboxRepositoryRootUrl()))
        {
            throw new MojoFailureException("Sandbox '" + getSandboxKey() + "' does not exist");
        }

        sandboxService.delete(getSandboxKey(), server.getUsername(), password, getSandboxRepositoryRootUrl());
        getLog().info("Sandbox '" + getSandboxKey() + "' has been deleted.");
    }

    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators
}
