/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox.scm;

import com.atlassian.maven.plugins.sandbox.ScmException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class SvnUtil {
    public static final String SVN_TRUNK = "trunk";
    public static final String SVN_BRANCHES = "branches";
    public static final String SVN_TAGS = "tags";
    public static final String[] SVN_BASE_DIRS = new String[]{"trunk", "branches", "tags"};

    private SvnUtil() {
    }

    @Nullable
    public static String resolveTagUrl(String repositoryUrl, String branchTagName) {
        String projectRoot = SvnUtil.getProjectRoot(repositoryUrl);
        if (StringUtils.isEmpty((String)(branchTagName = StringUtils.strip((String)branchTagName, (String)"/")))) {
            return null;
        }
        String queryString = null;
        if (repositoryUrl.contains("?")) {
            queryString = repositoryUrl.substring(repositoryUrl.indexOf("?"));
            projectRoot = StringUtils.replace((String)projectRoot, (String)queryString, (String)"");
        }
        if (branchTagName.contains("://")) {
            return branchTagName;
        }
        for (String SVN_BASE_DIR : SVN_BASE_DIRS) {
            if (!branchTagName.startsWith(SVN_BASE_DIR + "/")) continue;
            return SvnUtil.addSuffix(SvnUtil.appendPath(projectRoot, branchTagName), queryString);
        }
        return SvnUtil.addSuffix(SvnUtil.appendPath(SvnUtil.appendPath(projectRoot, SVN_TAGS), branchTagName), queryString);
    }

    private static String getProjectRoot(String repoPath) {
        for (String SVN_BASE_DIR : SVN_BASE_DIRS) {
            String base = "/" + SVN_BASE_DIR;
            int pos = repoPath.lastIndexOf(base + "/");
            if (repoPath.endsWith(base)) {
                return repoPath.substring(0, repoPath.length() - base.length());
            }
            if (pos < 0) continue;
            return repoPath.substring(0, pos);
        }
        return SvnUtil.appendPath(repoPath, null);
    }

    private static String appendPath(String basePath, @Nullable String addlPath) {
        basePath = StringUtils.stripEnd((String)basePath, (String)"/");
        if (StringUtils.isEmpty((String)addlPath)) {
            return basePath;
        }
        return basePath + "/" + StringUtils.stripStart((String)addlPath, (String)"/");
    }

    private static String addSuffix(String baseString, String suffix) {
        return suffix != null ? baseString + suffix : baseString;
    }

    public static int tag(Log log, String sandboxTagUrl, String releaseTagUrl, String commitMessage) throws ScmException {
        String command = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("svn", "cp", sandboxTagUrl, releaseTagUrl, "-m", commitMessage);
            command = org.apache.commons.lang.StringUtils.join(processBuilder.command(), (char)' ');
            log.info((CharSequence)("Running '" + command + "'"));
            Process process = processBuilder.start();
            return process.waitFor();
        }
        catch (Exception e) {
            throw new ScmException("An error has occured when running svn command: " + command, e);
        }
    }
}

