/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox.scm;

import com.atlassian.maven.plugins.sandbox.ScmException;
import com.atlassian.maven.plugins.sandbox.scm.ScmConnectionWrapper;
import com.atlassian.maven.plugins.sandbox.scm.ScmHandler;
import com.atlassian.maven.plugins.sandbox.scm.SvnUtil;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnHandler
implements ScmHandler {
    private final Log log;
    private final String connection;
    private final ScmConnectionWrapper connectionWrapper;

    public SvnHandler(Log log, @NotNull String connection) throws MojoFailureException {
        this.log = log;
        this.connection = connection;
        this.connectionWrapper = new ScmConnectionWrapper(connection);
    }

    @NotNull
    public String getBranch() throws ScmException {
        return this.connection;
    }

    public void assertValidWorkspace(String urlWeWantToPushTo, String expectedBranch, String originalWorkspace) {
    }

    public void createRemoteTagAndUpdateToIt(String destinationUrl, String revisionToTag, String tagName, String commitMessage) throws ScmException {
        int exitCode = SvnUtil.tag(this.log, revisionToTag, tagName, commitMessage);
        if (exitCode != 0) {
            this.log.error((CharSequence)("Release could not be tagged. Code: " + exitCode));
        }
    }

    @Nullable
    public String getTagString(String tagName) {
        return SvnUtil.resolveTagUrl(this.connectionWrapper.getUrl(), tagName);
    }
}

