/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox.scm;

import com.atlassian.maven.plugins.sandbox.scm.GitHandler;
import com.atlassian.maven.plugins.sandbox.scm.HgHandler;
import com.atlassian.maven.plugins.sandbox.scm.ScmConnectionWrapper;
import com.atlassian.maven.plugins.sandbox.scm.ScmHandler;
import com.atlassian.maven.plugins.sandbox.scm.ScmRoHandler;
import com.atlassian.maven.plugins.sandbox.scm.SvnHandler;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.Nullable;

public class ScmHandlerFactory {
    private ScmHandlerFactory() {
    }

    @Nullable
    public static ScmHandler createScmUtils(Log log, @Nullable String connection) throws MojoFailureException {
        if (connection == null) {
            return null;
        }
        ScmConnectionWrapper wrapper = new ScmConnectionWrapper(connection);
        switch (wrapper.getRepositoryType()) {
            case 2: {
                return new SvnHandler(log, connection);
            }
            case 1: {
                return new HgHandler(log);
            }
            case 3: {
                return new GitHandler(log);
            }
        }
        throw new MojoFailureException("Unknown repository type " + connection);
    }

    @Nullable
    public static ScmRoHandler createScmRoUtils(Log log, @Nullable String connection) throws MojoFailureException {
        return ScmHandlerFactory.createScmUtils(log, connection);
    }
}

