/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox.scm;

import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class ScmConnectionWrapper {
    protected static final String SCM_SVN_PREFIX = "scm:svn:";
    protected static final String SCM_HG_PREFIX = "scm:hg:";
    protected static final String SCM_GIT_PREFIX = "scm:git:";
    private final String url;
    private final int repositoryType;

    public ScmConnectionWrapper(String connection) throws MojoFailureException {
        if (ScmConnectionWrapper.isSvnConnection(connection)) {
            this.url = StringUtils.replace((String)connection, (String)SCM_SVN_PREFIX, (String)"");
            this.repositoryType = 2;
        } else if (ScmConnectionWrapper.isMercurialConnection(connection)) {
            this.url = StringUtils.replace((String)connection, (String)SCM_HG_PREFIX, (String)"");
            this.repositoryType = 1;
        } else if (ScmConnectionWrapper.isGitConnection(connection)) {
            this.url = StringUtils.replace((String)connection, (String)SCM_GIT_PREFIX, (String)"");
            this.repositoryType = 3;
        } else {
            throw new MojoFailureException("Repository '" + connection + "' is not a supported SCM system");
        }
    }

    public static boolean isSvnConnection(String url) {
        return url.startsWith(SCM_SVN_PREFIX);
    }

    public static boolean isMercurialConnection(String url) {
        return url.startsWith(SCM_HG_PREFIX);
    }

    public static boolean isGitConnection(String url) {
        return url.startsWith(SCM_GIT_PREFIX);
    }

    public String getUrl() {
        return this.url;
    }

    int getRepositoryType() {
        return this.repositoryType;
    }

    public String toString() {
        return this.url;
    }

    static class RepositoryType {
        public static final int HG = 1;
        public static final int SVN = 2;
        public static final int GIT = 3;

        private RepositoryType() {
        }
    }
}

