/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox.scm;

import com.atlassian.maven.plugins.sandbox.ScmException;
import com.atlassian.maven.plugins.sandbox.scm.CommandRunner;
import com.atlassian.maven.plugins.sandbox.scm.ScmHandler;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HgHandler
implements ScmHandler {
    private static final String HG = "hg";
    private final Log log;
    private final CommandRunner commandRunner;

    public HgHandler(Log log) {
        this.log = log;
        this.commandRunner = new CommandRunner(log);
    }

    @NotNull
    public String getBranch() throws ScmException {
        ArrayList<String> output = new ArrayList<String>();
        int exitCode = this.commandRunner.runCommand(output, HG, "branch");
        if (exitCode != 0 || output.size() != 1) {
            throw new ScmException("Unable to get the current branch name", exitCode, output);
        }
        return output.get(0).trim();
    }

    public void assertValidWorkspace(String urlWeWantToPushTo, String expectedBranch, String originalWorkspace) throws ScmException {
        ArrayList<String> output = new ArrayList<String>();
        int exitCode = this.commandRunner.runCommand(output, HG, "incoming", urlWeWantToPushTo);
        if (exitCode != 0 && exitCode != 1) {
            throw new ScmException("An error has occured when matching local workspace with repository at " + urlWeWantToPushTo + ", consider using " + originalWorkspace, exitCode, output);
        }
        String workspaceBranch = this.getBranch();
        if (!workspaceBranch.equals(expectedBranch)) {
            throw new ScmException("Workspace branch [" + workspaceBranch + "] does not match sandbox branch: [" + expectedBranch + "]" + ", consider using " + originalWorkspace);
        }
    }

    public void createRemoteTagAndUpdateToIt(String destinationUrl, String revisionToTag, String tagName, String commitMessage) throws ScmException {
        ArrayList<String> output = new ArrayList<String>();
        int exitCode = this.commandRunner.runCommand(output, HG, "pull", "-u", destinationUrl);
        if (exitCode != 0) {
            throw new ScmException("Unable to pull from " + destinationUrl, exitCode, output);
        }
        exitCode = this.commandRunner.runCommand(output, HG, "tag", "--force", "--message", commitMessage, "--rev", revisionToTag, tagName);
        if (exitCode != 0) {
            throw new ScmException("Unable to tag the local repository with " + tagName, exitCode, output);
        }
        exitCode = this.commandRunner.runCommand(output, HG, "push", destinationUrl);
        if (exitCode != 0) {
            throw new ScmException("Unable to push out tag commit to " + destinationUrl);
        }
        exitCode = this.commandRunner.runCommand(output, HG, "up", "-r", revisionToTag);
        if (exitCode != 0) {
            this.log.warn((CharSequence)("Unable to update workspace to " + revisionToTag));
        }
    }

    @Nullable
    public String getTagString(String tagName) {
        String hgTagName = StringUtils.strip((String)tagName, (String)"/");
        return StringUtils.isEmpty((String)hgTagName) ? null : hgTagName;
    }
}

