/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox.scm;

import com.atlassian.maven.plugins.sandbox.ScmException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRunner {
    private final Log log;

    public CommandRunner(Log log) {
        this.log = log;
    }

    public int runCommand(Collection<String> output, String ... arguments) throws ScmException {
        String command = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(arguments);
            processBuilder.redirectErrorStream(true);
            command = StringUtils.join(processBuilder.command(), (char)' ');
            this.log.info((CharSequence)("Running command: '" + command + "'."));
            Process process = processBuilder.start();
            List processOutput = IOUtils.readLines((InputStream)process.getInputStream());
            output.clear();
            output.addAll(processOutput);
            return process.waitFor();
        }
        catch (Exception e) {
            throw new ScmException("An error has occurred when running hg command: " + command, e);
        }
    }
}

